<?php
/**
 * Script de debug para verificar actividades en la base de datos
 */

require_once 'database/config.php';
require_once 'database/connection.php';

try {
    $db = getDB();
    
    echo "<h2>Debug de Actividades</h2>\n";
    
    // Verificar estructura de la tabla lead_activities
    echo "<h3>1. Estructura de la tabla lead_activities:</h3>\n";
    $columns = $db->select("DESCRIBE lead_activities");
    echo "<pre>";
    foreach ($columns as $column) {
        echo "Campo: {$column['Field']}, Tipo: {$column['Type']}, Null: {$column['Null']}, Key: {$column['Key']}\n";
    }
    echo "</pre>";
    
    // Contar total de actividades
    echo "<h3>2. Total de actividades en la base de datos:</h3>\n";
    $total = $db->selectOne("SELECT COUNT(*) as total FROM lead_activities");
    echo "<p>Total de actividades: " . $total['total'] . "</p>\n";
    
    // Mostrar últimas 10 actividades
    echo "<h3>3. Últimas 10 actividades:</h3>\n";
    $activities = $db->select("
        SELECT la.*, u.username, l.first_name, l.last_name 
        FROM lead_activities la 
        LEFT JOIN users u ON la.created_by = u.id 
        LEFT JOIN leads l ON la.lead_id = l.id 
        ORDER BY la.created_at DESC 
        LIMIT 10
    ");
    
    if (empty($activities)) {
        echo "<p style='color: red;'>No hay actividades en la base de datos</p>\n";
    } else {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>\n";
        echo "<tr><th>ID</th><th>Lead</th><th>Tipo</th><th>Asunto</th><th>Descripción</th><th>Creado por</th><th>Fecha</th></tr>\n";
        foreach ($activities as $activity) {
            echo "<tr>";
            echo "<td>{$activity['id']}</td>";
            echo "<td>{$activity['first_name']} {$activity['last_name']}</td>";
            echo "<td>{$activity['type']}</td>";
            echo "<td>{$activity['subject']}</td>";
            echo "<td>" . substr($activity['description'], 0, 50) . "...</td>";
            echo "<td>{$activity['username']}</td>";
            echo "<td>{$activity['created_at']}</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
    
    // Verificar actividades para lead específico (ID 3)
    echo "<h3>4. Actividades para Lead ID 3:</h3>\n";
    $lead3_activities = $db->select("
        SELECT * FROM lead_activities 
        WHERE lead_id = 3 
        ORDER BY created_at DESC
    ");
    
    if (empty($lead3_activities)) {
        echo "<p style='color: orange;'>No hay actividades para el Lead ID 3</p>\n";
    } else {
        echo "<p style='color: green;'>Encontradas " . count($lead3_activities) . " actividades para Lead ID 3</p>\n";
        foreach ($lead3_activities as $activity) {
            echo "<p>- {$activity['type']}: {$activity['subject']} ({$activity['created_at']})</p>\n";
        }
    }
    
    // Verificar si existe el lead ID 3
    echo "<h3>5. Verificar Lead ID 3:</h3>\n";
    $lead = $db->selectOne("SELECT * FROM leads WHERE id = 3");
    if ($lead) {
        echo "<p style='color: green;'>Lead ID 3 existe: {$lead['first_name']} {$lead['last_name']}</p>\n";
    } else {
        echo "<p style='color: red;'>Lead ID 3 NO existe en la base de datos</p>\n";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>\n";
    echo "<pre>" . $e->getTraceAsString() . "</pre>\n";
}
?>