<?php
/**
 * Archivo de diagnóstico para ProfixCRM
 * Verificar funcionamiento básico del sistema
 */

// Habilitar reporte de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Diagnóstico ProfixCRM</h1>";
echo "<hr>";

// 1. Verificar PHP
echo "<h2>1. Información PHP</h2>";
echo "Versión PHP: " . phpversion() . "<br>";
echo "Memoria límite: " . ini_get('memory_limit') . "<br>";
echo "Tiempo máximo ejecución: " . ini_get('max_execution_time') . "<br>";
echo "<br>";

// 2. Verificar archivos principales
echo "<h2>2. Archivos del Sistema</h2>";
$files_to_check = [
    'index.php',
    'database/config.php',
    'database/config.prod.php',
    'database/connection.php',
    'modules/auth/login.php',
    'modules/dashboard/index.php'
];

foreach ($files_to_check as $file) {
    $path = __DIR__ . '/' . $file;
    if (file_exists($path)) {
        echo "✓ $file - OK<br>";
    } else {
        echo "✗ $file - NO ENCONTRADO<br>";
    }
}
echo "<br>";

// 3. Verificar configuración de base de datos
echo "<h2>3. Configuración Base de Datos</h2>";
try {
    require_once __DIR__ . '/database/config.php';
    
    echo "Host: " . (defined('DB_HOST') ? DB_HOST : 'NO DEFINIDO') . "<br>";
    echo "Puerto: " . (defined('DB_PORT') ? DB_PORT : 'NO DEFINIDO') . "<br>";
    echo "Base de datos: " . (defined('DB_NAME') ? DB_NAME : 'NO DEFINIDO') . "<br>";
    echo "Usuario: " . (defined('DB_USER') ? DB_USER : 'NO DEFINIDO') . "<br>";
    echo "Contraseña: " . (defined('DB_PASS') ? (DB_PASS ? '***CONFIGURADA***' : 'VACÍA') : 'NO DEFINIDO') . "<br>";
    echo "<br>";
    
    // 4. Probar conexión a base de datos
    echo "<h2>4. Conexión Base de Datos</h2>";
    require_once __DIR__ . '/database/connection.php';
    
    if (isset($pdo) && $pdo instanceof PDO) {
        echo "✓ Conexión PDO establecida correctamente<br>";
        
        // Verificar si existe la tabla users
        $stmt = $pdo->query("SHOW TABLES LIKE 'users'");
        if ($stmt->rowCount() > 0) {
            echo "✓ Tabla 'users' encontrada<br>";
            
            // Contar usuarios
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM users");
            $result = $stmt->fetch();
            echo "Usuarios en sistema: " . $result['count'] . "<br>";
        } else {
            echo "✗ Tabla 'users' no encontrada - Base de datos no inicializada<br>";
        }
    } else {
        echo "✗ Error en conexión PDO<br>";
    }
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
}

echo "<br>";

// 5. Verificar sesiones
echo "<h2>5. Sesiones</h2>";
session_start();
echo "ID de sesión: " . session_id() . "<br>";
echo "Estado sesión: " . (session_status() === PHP_SESSION_ACTIVE ? 'ACTIVA' : 'INACTIVA') . "<br>";
echo "<br>";

// 6. Verificar permisos de archivos
echo "<h2>6. Permisos de Archivos</h2>";
$directories_to_check = [
    '.',
    'modules',
    'database',
    'public'
];

foreach ($directories_to_check as $dir) {
    $path = __DIR__ . '/' . $dir;
    if (is_dir($path)) {
        echo "$dir: " . (is_readable($path) ? 'LEGIBLE' : 'NO LEGIBLE') . " | " . (is_writable($path) ? 'ESCRIBIBLE' : 'NO ESCRIBIBLE') . "<br>";
    }
}

echo "<br>";
echo "<h2>Diagnóstico Completado</h2>";
echo "<p><a href='index.php'>Ir al sistema principal</a></p>";
?>