<?php
/**
 * Configuración de Base de Datos - ProfixCRM Simple
 */

// Cargar override local si existe; en su defecto, producción
if (file_exists(__DIR__ . '/config.local.php')) {
    require_once __DIR__ . '/config.local.php';
} elseif (file_exists(__DIR__ . '/config.prod.php')) {
    require_once __DIR__ . '/config.prod.php';
}

// Configuración de la base de datos (valores por defecto, no sobreescribir si ya existen)
if (!defined('DB_HOST')) define('DB_HOST', 'localhost');
if (!defined('DB_PORT')) define('DB_PORT', '3306');
if (!defined('DB_NAME')) define('DB_NAME', 'simple_crm');
if (!defined('DB_USER')) define('DB_USER', 'root');
if (!defined('DB_PASS')) define('DB_PASS', '');
if (!defined('DB_CHARSET')) define('DB_CHARSET', 'utf8mb4');

// Configuración de la aplicación
if (!defined('APP_NAME')) define('APP_NAME', 'ProfixCRM Simple');
if (!defined('APP_VERSION')) define('APP_VERSION', '1.0');
if (!defined('APP_TIMEZONE')) define('APP_TIMEZONE', 'America/Mexico_City');
if (!defined('APP_SECRET')) define('APP_SECRET', 'change-me-secret');

// Configuración de seguridad
if (!defined('SESSION_LIFETIME')) define('SESSION_LIFETIME', 7200); // 2 horas
if (!defined('PASSWORD_MIN_LENGTH')) define('PASSWORD_MIN_LENGTH', 6);

// Establecer zona horaria
date_default_timezone_set(APP_TIMEZONE);
