-- Agregar permisos específicos para integraciones API
-- Este script agrega permisos granulares para cada integración

-- Permisos generales de integraciones
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('integrations.view', 'Ver Integraciones', 'Permite ver la página de integraciones', 'integrations', 'view', TRUE),
('integrations.manage', 'Gestionar Integraciones', 'Permite gestionar todas las integraciones', 'integrations', 'manage', TRUE);

-- Permisos específicos de Big4pay
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('big4pay.view', 'Ver Big4pay', 'Permite ver la configuración de Big4pay', 'integrations', 'big4pay.view', TRUE),
('big4pay.configure', 'Configurar Big4pay', 'Permite configurar la integración de Big4pay', 'integrations', 'big4pay.configure', TRUE),
('big4pay.test', 'Probar Big4pay', 'Permite ejecutar pruebas de la integración Big4pay', 'integrations', 'big4pay.test', TRUE),
('big4pay.process_payments', 'Procesar Pagos Big4pay', 'Permite procesar pagos a través de Big4pay', 'integrations', 'big4pay.process_payments', TRUE);

-- Permisos específicos de Key2Pay
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('key2pay.view','Ver Key2Pay','Permite ver la configuración de Key2Pay','integrations','key2pay.view',TRUE),
('key2pay.configure','Configurar Key2Pay','Permite configurar la integración de Key2Pay','integrations','key2pay.configure',TRUE),
('key2pay.test','Probar Key2Pay','Permite ejecutar pruebas de la integración Key2Pay','integrations','key2pay.test',TRUE),
('key2pay.process_payments','Procesar Pagos Key2Pay','Permite procesar pagos a través de Key2Pay','integrations','key2pay.process_payments',TRUE);

-- Permisos específicos de Voiso
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('voiso.view', 'Ver Voiso', 'Permite ver la configuración de Voiso', 'integrations', 'voiso.view', TRUE),
('voiso.configure', 'Configurar Voiso', 'Permite configurar la integración de Voiso', 'integrations', 'voiso.configure', TRUE),
('voiso.test', 'Probar Voiso', 'Permite ejecutar pruebas de la integración Voiso', 'integrations', 'voiso.test', TRUE),
('voiso.manage_calls', 'Gestionar Llamadas Voiso', 'Permite gestionar llamadas a través de Voiso', 'integrations', 'voiso.manage_calls', TRUE);

-- Permisos para futuras integraciones API
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('api.webhooks.manage', 'Gestionar Webhooks', 'Permite gestionar webhooks de integraciones', 'integrations', 'api.webhooks.manage', TRUE),
('api.keys.manage', 'Gestionar API Keys', 'Permite gestionar claves de API', 'integrations', 'api.keys.manage', TRUE),
('api.logs.view', 'Ver Logs de API', 'Permite ver logs de integraciones API', 'integrations', 'api.logs.view', TRUE);

-- Asignar permisos de integraciones al rol Admin
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id FROM roles r, permissions p 
WHERE r.name = 'admin' AND p.module = 'integrations';

-- Asignar permisos de integraciones al rol Manager
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id FROM roles r, permissions p 
WHERE r.name = 'manager' AND p.module = 'integrations' 
AND p.name NOT IN ('api.keys.manage'); -- Managers no pueden gestionar API keys

-- Asignar permisos básicos de integraciones al rol Sales
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id FROM roles r, permissions p 
WHERE r.name = 'Sales' AND p.name IN (
    'integrations.view',
    'big4pay.view', 'big4pay.configure', 'big4pay.test',
    'voiso.view', 'voiso.configure', 'voiso.test'
);

-- Mantener el permiso payments.configure para compatibilidad
-- (ya existe, solo verificamos que esté asignado)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id FROM roles r, permissions p 
WHERE r.name IN ('admin', 'manager', 'Sales') AND p.name = 'payments.configure';
