<?php
/**
 * Finage API Configuration
 * Configure your Finage API key here for real-time market data
 */

return [
    'api_key' => 'API_KEYa9S26XB6LLM6JOJH2VIWX4SKS7I8KGPQ', // Finage HTTP API key
    'socket_key' => 'SOCKET_KEYljicpjlfpaihdbhldomfjmfeoplkfnikkfdackainlg', // Finage WebSocket subscription key
    'base_url' => 'https://api.finage.co.uk',
    'websocket_url' => 'wss://w1.finage.co.uk/websocket/', // fallback WS
    'ws_servers' => [
        'stocks' => 'wss://xs68rzvrjn.finage.ws:7003',
        'forex' =>  'wss://w29hxx2ndd.finage.ws:8001',
        'crypto' => 'wss://42xvum6unt.finage.ws:6006',
        'indices' => 'wss://5rgw2pysvk.finage.ws:9002',
        'etf' =>     'wss://5rgw2pysvk.finage.ws:9002' // same server if applicable
    ],
    'timeout' => 10,
    'retry_attempts' => 3,
    'default_symbols' => [
        'EURUSD',
        'GBPUSD', 
        'USDJPY',
        'USDCHF',
        'AUDUSD',
        'USDCAD',
        'NZDUSD',
        'EURJPY'
    ],
    'stock_symbols' => [
        'AMZN',
        'AAPL',
        'TSLA',
        'MSFT',
        'ADBE',
        'ADDYY',
        'ADSK'
    ],
    'crypto_symbols' => [
        'BTCUSD'
    ],
    'indices_symbols' => [
        'SPX',
        'NDX'
    ],
    'etf_symbols' => [
        'SPY',
        'QQQ'
    ],
    'endpoints' => [
        'forex_last' => '/last/forex/{symbol}',
        'crypto_last' => '/last/crypto/{symbol}',
        'stock_snapshot' => '/snapshot/stock',
        'historical_forex' => '/agg/forex/{symbol}/{period}',
        'historical_crypto' => '/agg/crypto/{symbol}/{period}',
        'historical_stock' => '/agg/stock/{symbol}/{period}',
        'market_status' => '/market-status/forex'
    ]
];

/*
 * To get a Finage API key:
 * 1. Visit https://finage.co.uk
 * 2. Sign up for a free account
 * 3. Get your API key from the dashboard
 * 4. Replace 'YOUR_FINAGE_API_KEY_HERE' with your actual key
 * 
 * Note: The free tier includes limited requests per month.
 * For production use, consider upgrading to a paid plan.
 */
?>
