<?php
require_once 'database/connection.php';

$db = Database::getInstance();

try {
    // Check if trading_accounts table exists
    $result = $db->select("SHOW TABLES LIKE 'trading_accounts'");
    
    if (empty($result)) {
        echo "Table trading_accounts does not exist\n";
        
        // Create the table
        $createTable = "
        CREATE TABLE IF NOT EXISTS trading_accounts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            client_id INT NOT NULL,
            account_type ENUM('demo', 'live') DEFAULT 'demo',
            account_number VARCHAR(20) UNIQUE,
            balance DECIMAL(18,2) DEFAULT 0.00,
            equity DECIMAL(18,2) DEFAULT 0.00,
            margin DECIMAL(18,2) DEFAULT 0.00,
            free_margin DECIMAL(18,2) DEFAULT 0.00,
            leverage INT DEFAULT 100,
            currency VARCHAR(3) DEFAULT 'USD',
            status ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX idx_client_id (client_id),
            INDEX idx_status (status)
        )";
        
        $db->execute($createTable);
        echo "Created trading_accounts table\n";
        
    } else {
        echo "Table trading_accounts exists\n";
        
        // Show table structure
        $columns = $db->select("DESCRIBE trading_accounts");
        foreach ($columns as $column) {
            echo $column['Field'] . " - " . $column['Type'] . "\n";
        }
    }
    
    // Check if trading_positions table exists
    $result = $db->select("SHOW TABLES LIKE 'trading_positions'");
    if (empty($result)) {
        echo "\nTable trading_positions does not exist\n";
        
        $createPositions = "
        CREATE TABLE IF NOT EXISTS trading_positions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            account_id INT NOT NULL,
            symbol VARCHAR(10) NOT NULL,
            type ENUM('buy', 'sell') NOT NULL,
            volume DECIMAL(10,2) NOT NULL,
            open_price DECIMAL(10,5) NOT NULL,
            current_price DECIMAL(10,5) DEFAULT 0,
            stop_loss DECIMAL(10,5) DEFAULT NULL,
            take_profit DECIMAL(10,5) DEFAULT NULL,
            profit DECIMAL(18,2) DEFAULT 0,
            status ENUM('open', 'closed') DEFAULT 'open',
            opened_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            closed_at DATETIME NULL,
            INDEX idx_account_id (account_id),
            INDEX idx_status (status)
        )";
        
        $db->execute($createPositions);
        echo "Created trading_positions table\n";
    } else {
        echo "\nTable trading_positions exists\n";
    }
    
    // Check if trading_orders table exists
    $result = $db->select("SHOW TABLES LIKE 'trading_orders'");
    if (empty($result)) {
        echo "\nTable trading_orders does not exist\n";
        
        $createOrders = "
        CREATE TABLE IF NOT EXISTS trading_orders (
            id INT AUTO_INCREMENT PRIMARY KEY,
            account_id INT NOT NULL,
            symbol VARCHAR(10) NOT NULL,
            type ENUM('buy_limit', 'sell_limit', 'buy_stop', 'sell_stop') NOT NULL,
            volume DECIMAL(10,2) NOT NULL,
            price DECIMAL(10,5) NOT NULL,
            stop_loss DECIMAL(10,5) DEFAULT NULL,
            take_profit DECIMAL(10,5) DEFAULT NULL,
            status ENUM('pending', 'executed', 'cancelled') DEFAULT 'pending',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            executed_at DATETIME NULL,
            INDEX idx_account_id (account_id),
            INDEX idx_status (status)
        )";
        
        $db->execute($createOrders);
        echo "Created trading_orders table\n";
    } else {
        echo "\nTable trading_orders exists\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>