<?php
require_once 'database/connection.php';

echo "<h2>Verificación de Leads en Producción</h2>";

// 1. Verificar si el lead 10292 existe
echo "<h3>1. Verificar lead 10292:</h3>";
try {
    $lead_10292 = $db->select("SELECT * FROM leads WHERE id = ?", [10292]);
    if ($lead_10292) {
        echo "✅ Lead 10292 encontrado:<br>";
        echo "<pre>";
        print_r($lead_10292[0]);
        echo "</pre>";
    } else {
        echo "❌ Lead 10292 NO encontrado en la base de datos<br>";
    }
} catch (Exception $e) {
    echo "❌ Error verificando lead 10292: " . $e->getMessage() . "<br>";
}

// 2. Buscar leads existentes
echo "<h3>2. Leads existentes en la base de datos:</h3>";
try {
    $existing_leads = $db->select("SELECT id, first_name, last_name, email, assigned_to, desk_id, status FROM leads ORDER BY id DESC LIMIT 10");
    if ($existing_leads) {
        echo "✅ Se encontraron " . count($existing_leads) . " leads:<br>";
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>Nombre</th><th>Email</th><th>Assigned To</th><th>Desk ID</th><th>Status</th></tr>";
        foreach ($existing_leads as $lead) {
            echo "<tr>";
            echo "<td>" . $lead['id'] . "</td>";
            echo "<td>" . $lead['first_name'] . " " . $lead['last_name'] . "</td>";
            echo "<td>" . $lead['email'] . "</td>";
            echo "<td>" . ($lead['assigned_to'] ?? 'NULL') . "</td>";
            echo "<td>" . ($lead['desk_id'] ?? 'NULL') . "</td>";
            echo "<td>" . $lead['status'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "❌ No se encontraron leads en la base de datos<br>";
    }
} catch (Exception $e) {
    echo "❌ Error obteniendo leads: " . $e->getMessage() . "<br>";
}

// 3. Contar total de leads
echo "<h3>3. Total de leads en la base de datos:</h3>";
try {
    $total = $db->selectOne("SELECT COUNT(*) as total FROM leads");
    echo "Total de leads: " . $total['total'] . "<br>";
} catch (Exception $e) {
    echo "❌ Error contando leads: " . $e->getMessage() . "<br>";
}

// 4. Verificar leads con assigned_to y desk_id
echo "<h3>4. Leads con asignación y desk:</h3>";
try {
    $assigned_leads = $db->select("SELECT id, first_name, last_name, assigned_to, desk_id FROM leads WHERE assigned_to IS NOT NULL AND desk_id IS NOT NULL LIMIT 5");
    if ($assigned_leads) {
        echo "✅ Leads con asignación y desk:<br>";
        foreach ($assigned_leads as $lead) {
            echo "- ID: " . $lead['id'] . " | " . $lead['first_name'] . " " . $lead['last_name'] . " | Assigned: " . $lead['assigned_to'] . " | Desk: " . $lead['desk_id'] . "<br>";
        }
    } else {
        echo "❌ No se encontraron leads con asignación y desk<br>";
    }
} catch (Exception $e) {
    echo "❌ Error buscando leads asignados: " . $e->getMessage() . "<br>";
}

// 5. Verificar configuración de base de datos
echo "<h3>5. Información de conexión:</h3>";
try {
    $pdo = $db->getConnection();
    echo "✅ Conexión a base de datos exitosa<br>";
    
    // Obtener información de la base de datos
    $db_info = $pdo->query("SELECT DATABASE() as db_name")->fetch();
    echo "Base de datos actual: " . $db_info['db_name'] . "<br>";
    
} catch (Exception $e) {
    echo "❌ Error con la conexión: " . $e->getMessage() . "<br>";
}

// 6. Buscar leads similares al ID 10292
echo "<h3>6. Leads con IDs similares:</h3>";
try {
    $similar_leads = $db->select("SELECT id, first_name, last_name FROM leads WHERE id BETWEEN 10290 AND 10295 ORDER BY id");
    if ($similar_leads) {
        echo "✅ Leads con IDs similares:<br>";
        foreach ($similar_leads as $lead) {
            echo "- ID: " . $lead['id'] . " | " . $lead['first_name'] . " " . $lead['last_name'] . "<br>";
        }
    } else {
        echo "❌ No se encontraron leads con IDs similares<br>";
    }
} catch (Exception $e) {
    echo "❌ Error buscando leads similares: " . $e->getMessage() . "<br>";
}
?>