<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Revisar Logs de Producción</h2>";

// Función para leer las últimas líneas de un archivo
function tail($filename, $lines = 50) {
    if (!file_exists($filename)) {
        return "Archivo no existe: $filename";
    }
    
    $file = file($filename);
    if ($file === false) {
        return "No se puede leer el archivo: $filename";
    }
    
    return implode('', array_slice($file, -$lines));
}

// Archivos de log a revisar
$log_files = [
    'Error Log PHP' => ini_get('error_log'),
    'Log General' => 'logs/general.log',
    'Log Crítico' => 'logs/critical_errors.log',
    'Log Todos los Errores' => 'logs/all_errors.log'
];

echo "<h3>Logs del Sistema</h3>";

foreach ($log_files as $name => $file) {
    echo "<h4>$name</h4>";
    
    if ($file && file_exists($file)) {
        echo "<p><strong>Archivo:</strong> $file</p>";
        echo "<p><strong>Últimas 30 líneas:</strong></p>";
        echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd; max-height: 300px; overflow-y: auto;'>";
        echo htmlspecialchars(tail($file, 30));
        echo "</pre>";
    } else {
        echo "<p>❌ Archivo no encontrado: $file</p>";
    }
}

// Buscar logs específicos de VIEW.PHP
echo "<h3>Logs Específicos de VIEW.PHP</h3>";

$error_log_file = ini_get('error_log');
if ($error_log_file && file_exists($error_log_file)) {
    $content = file_get_contents($error_log_file);
    $view_logs = [];
    
    $lines = explode("\n", $content);
    foreach ($lines as $line) {
        if (strpos($line, 'VIEW.PHP:') !== false) {
            $view_logs[] = $line;
        }
    }
    
    if (!empty($view_logs)) {
        echo "<p><strong>Últimas " . count($view_logs) . " entradas de VIEW.PHP:</strong></p>";
        echo "<pre style='background: #f0f8ff; padding: 10px; border: 1px solid #007acc; max-height: 400px; overflow-y: auto;'>";
        foreach (array_slice($view_logs, -20) as $log) {
            echo htmlspecialchars($log) . "\n";
        }
        echo "</pre>";
    } else {
        echo "<p>⚠️ No se encontraron logs de VIEW.PHP</p>";
    }
} else {
    echo "<p>❌ No se puede acceder al error log de PHP</p>";
}

// Información del sistema
echo "<h3>Información del Sistema</h3>";
echo "<ul>";
echo "<li><strong>Error Log PHP:</strong> " . (ini_get('error_log') ?: 'No configurado') . "</li>";
echo "<li><strong>Log Errors:</strong> " . (ini_get('log_errors') ? 'Activado' : 'Desactivado') . "</li>";
echo "<li><strong>Display Errors:</strong> " . (ini_get('display_errors') ? 'Activado' : 'Desactivado') . "</li>";
echo "<li><strong>Error Reporting:</strong> " . error_reporting() . "</li>";
echo "<li><strong>Fecha/Hora:</strong> " . date('Y-m-d H:i:s') . "</li>";
echo "</ul>";

// Probar logging
echo "<h3>Probar Logging</h3>";
error_log("TEST: Probando logging desde check_logs_production.php - " . date('Y-m-d H:i:s'));
echo "<p>✅ Se envió un mensaje de prueba al log. Revise arriba si aparece.</p>";

// Sugerir próximos pasos
echo "<h3>Próximos Pasos</h3>";
echo "<ol>";
echo "<li>Intente acceder a un lead específico en producción</li>";
echo "<li>Refresque esta página para ver los nuevos logs</li>";
echo "<li>Busque mensajes que empiecen con 'VIEW.PHP:' para ver el flujo de ejecución</li>";
echo "</ol>";

// Enlaces útiles
echo "<h3>Enlaces de Prueba</h3>";
echo "<p>Después de intentar acceder a un lead, use estos enlaces:</p>";
echo "<ul>";
echo "<li><a href='check_logs_production.php'>Refrescar esta página</a></li>";
echo "<li><a href='test_lead_production.php'>Ver leads disponibles</a></li>";
echo "</ul>";

?>