<?php
require_once 'database/connection.php';

$lead_id = 10292;

try {
    $stmt = $pdo->prepare("SELECT * FROM leads WHERE id = ?");
    $stmt->execute([$lead_id]);
    $lead = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<h2>Verificación del Lead ID: $lead_id</h2>";
    
    if ($lead) {
        echo "<h3>✅ Lead encontrado:</h3>";
        echo "<pre>";
        print_r($lead);
        echo "</pre>";
    } else {
        echo "<h3>❌ Lead NO encontrado</h3>";
        
        // Verificar cuántos leads existen
        $count_stmt = $pdo->query("SELECT COUNT(*) as total FROM leads");
        $total = $count_stmt->fetch(PDO::FETCH_ASSOC)['total'];
        echo "<p>Total de leads en la base de datos: $total</p>";
        
        // Mostrar algunos IDs existentes
        $existing_stmt = $pdo->query("SELECT id, first_name, last_name FROM leads ORDER BY id DESC LIMIT 10");
        $existing_leads = $existing_stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if ($existing_leads) {
            echo "<h4>Últimos 10 leads existentes:</h4>";
            echo "<ul>";
            foreach ($existing_leads as $existing_lead) {
                echo "<li>ID: {$existing_lead['id']} - {$existing_lead['first_name']} {$existing_lead['last_name']}</li>";
            }
            echo "</ul>";
        }
    }
    
} catch (Exception $e) {
    echo "<h3>❌ Error de conexión:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>