<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Verificar Estructura de Tabla Desks</h2>";

require_once 'database/config.php';
require_once 'database/connection.php';

try {
    $db = getDB();
    $pdo = $db->getConnection();
    
    echo "<h3>1. Estructura de la tabla 'desks'</h3>";
    
    // Verificar si la tabla existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'desks'");
    $table_exists = $stmt->fetch();
    
    if ($table_exists) {
        echo "<p>✅ Tabla 'desks' existe</p>";
        
        // Mostrar estructura de la tabla
        $stmt = $pdo->query("DESCRIBE desks");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h4>Columnas actuales:</h4>";
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        
        $has_color = false;
        foreach ($columns as $column) {
            echo "<tr>";
            echo "<td>{$column['Field']}</td>";
            echo "<td>{$column['Type']}</td>";
            echo "<td>{$column['Null']}</td>";
            echo "<td>{$column['Key']}</td>";
            echo "<td>{$column['Default']}</td>";
            echo "<td>{$column['Extra']}</td>";
            echo "</tr>";
            
            if ($column['Field'] === 'color') {
                $has_color = true;
            }
        }
        echo "</table>";
        
        if ($has_color) {
            echo "<p>✅ La columna 'color' existe</p>";
        } else {
            echo "<p>❌ La columna 'color' NO existe</p>";
            echo "<p><strong>Esta es la causa del error!</strong></p>";
        }
        
    } else {
        echo "<p>❌ Tabla 'desks' NO existe</p>";
    }
    
    echo "<h3>2. Contenido de la tabla 'desks'</h3>";
    
    if ($table_exists) {
        $stmt = $pdo->query("SELECT * FROM desks LIMIT 10");
        $desks = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if ($desks) {
            echo "<p>Registros encontrados: " . count($desks) . "</p>";
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            
            // Encabezados
            echo "<tr>";
            foreach (array_keys($desks[0]) as $header) {
                echo "<th>$header</th>";
            }
            echo "</tr>";
            
            // Datos
            foreach ($desks as $desk) {
                echo "<tr>";
                foreach ($desk as $value) {
                    echo "<td>" . htmlspecialchars($value ?? '') . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p>⚠️ No hay registros en la tabla desks</p>";
        }
    }
    
    echo "<h3>3. Solución Propuesta</h3>";
    
    if ($table_exists && !$has_color) {
        echo "<p><strong>Problema identificado:</strong> La tabla 'desks' no tiene la columna 'color'</p>";
        echo "<p><strong>Soluciones:</strong></p>";
        echo "<ol>";
        echo "<li><strong>Opción 1 (Recomendada):</strong> Agregar la columna 'color' a la tabla</li>";
        echo "<li><strong>Opción 2:</strong> Modificar las consultas para no usar la columna 'color'</li>";
        echo "</ol>";
        
        echo "<h4>SQL para agregar la columna:</h4>";
        echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd;'>";
        echo "ALTER TABLE desks ADD COLUMN color VARCHAR(7) DEFAULT '#007bff';";
        echo "</pre>";
        
        echo "<h4>O ejecutar automáticamente:</h4>";
        echo "<p><a href='?add_color_column=1' style='background: #007bff; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;'>Agregar Columna Color</a></p>";
    }
    
    // Ejecutar la corrección si se solicita
    if (isset($_GET['add_color_column']) && $_GET['add_color_column'] == '1') {
        echo "<h3>4. Ejecutando Corrección</h3>";
        
        try {
            $pdo->exec("ALTER TABLE desks ADD COLUMN color VARCHAR(7) DEFAULT '#007bff'");
            echo "<p>✅ Columna 'color' agregada exitosamente</p>";
            echo "<p><a href='check_desks_structure.php'>Refrescar para verificar</a></p>";
        } catch (Exception $e) {
            echo "<p>❌ Error agregando columna: " . $e->getMessage() . "</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h3>5. Próximos Pasos</h3>";
echo "<ol>";
echo "<li>Si agregó la columna 'color', pruebe acceder al lead nuevamente</li>";
echo "<li>Si prefiere no agregar la columna, modifique las consultas en view.php</li>";
echo "<li>Verifique que otros módulos no dependan de la columna 'color'</li>";
echo "</ol>";

?>