<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__, 2))); }
require_once BASE_PATH . '/database/connection.php';
header('Content-Type: application/json; charset=utf-8');

try {
    $raw = file_get_contents('php://input');
    $json = json_decode($raw, true);
    if (!$json || !is_array($json)) { $json = $_POST ?: $_GET ?: []; }

    $status = strtolower($json['status'] ?? $json['paymentStatus'] ?? $json['payment_status'] ?? '');
    $orderId = $json['orderId'] ?? $json['identifier'] ?? null;
    $uid = $json['uid'] ?? $json['payment']['uid'] ?? null;
    $amount = $json['amount'] ?? ($json['payment']['amount'] ?? null);
    $currency = strtoupper($json['currency'] ?? ($json['payment']['currency'] ?? 'USD'));
    $pmLabel = $json['payment_method'] ?? ($json['paymentMethod'] ?? ($json['payment']['method_label'] ?? ($json['payment']['method'] ?? '')));
    $channel = strtolower($json['channel'] ?? ($json['payment']['channel'] ?? ''));
    if (is_array($json['paymentMethod'] ?? null)) { $channel = $channel ?: strtolower($json['paymentMethod']['channel'] ?? ''); }
    if ($channel === '') {
        $cat = strtolower($json['category'] ?? ($json['payment']['category'] ?? ''));
        if (in_array($cat, ['cash'])) $channel = 'cash'; else if ($cat!=='') $channel = 'online';
    }
    // Normalizar unidades: si es entero, dividir por 100 para almacenamiento, si es decimal, usar tal cual
    $amountVal = is_numeric($amount) ? (float)$amount : 0.0;
    if ($amountVal > 0 && floor($amountVal) == $amountVal && $amountVal > 1000) { $amountVal = $amountVal / 100.0; }

    $db = Database::getInstance();
    $pdo = $db->getConnection();

    // Log básico
    $dir = dirname(__DIR__, 3) . '/tmp'; if (!is_dir($dir)) { @mkdir($dir, 0777, true); }
    @file_put_contents($dir . '/key2pay_ipn.log', json_encode(['ts'=>date('c'),'event'=>$json]) . PHP_EOL, FILE_APPEND | LOCK_EX);

    // Tabla de intentos
    $pdo->exec("CREATE TABLE IF NOT EXISTS payment_attempts (
      id INT AUTO_INCREMENT PRIMARY KEY,
      client_id INT NULL,
      account_number VARCHAR(64) NULL,
      method VARCHAR(64) NOT NULL,
      identifier VARCHAR(64) NOT NULL,
      amount DECIMAL(18,6) NOT NULL,
      currency VARCHAR(8) NOT NULL,
      status VARCHAR(32) NOT NULL,
      payment_method VARCHAR(64) NULL,
      channel VARCHAR(32) NULL,
      external_transaction_id VARCHAR(128) NULL,
      source VARCHAR(32) NOT NULL,
      redirect_url VARCHAR(255) NULL,
      checkout_url VARCHAR(255) NULL,
      message TEXT NULL,
      raw_json JSON NULL,
      created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
      updated_at DATETIME NULL,
      UNIQUE KEY uniq_identifier (identifier)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    try { $pdo->exec("ALTER TABLE payment_attempts ADD COLUMN payment_method VARCHAR(64) NULL"); } catch (Throwable $__) {}
    try { $pdo->exec("ALTER TABLE payment_attempts ADD COLUMN channel VARCHAR(32) NULL"); } catch (Throwable $__) {}

    $identifier = $orderId ?: ($uid ?: null);
    if ($identifier) {
        $stmtSel = $pdo->prepare("SELECT * FROM payment_attempts WHERE identifier = ? LIMIT 1");
        $stmtSel->execute([$identifier]);
        $row = $stmtSel->fetch(PDO::FETCH_ASSOC);
        if ($row) {
            $stmtUp = $pdo->prepare("UPDATE payment_attempts SET status=?, payment_method=?, channel=?, raw_json=?, updated_at=NOW() WHERE id=?");
            $stmtUp->execute([$status ?: 'unknown', $pmLabel ?: null, $channel ?: null, json_encode($json), (int)$row['id']]);
            $clientId = (int)($row['client_id'] ?? 0);
            $accNum = $row['account_number'] ?? '';
            if (in_array($status, ['approved','paid','success','completed'])) {
                // Registrar depósito y acreditar saldo
                if ($clientId > 0) {
                    try { $pdo->exec("CREATE TABLE IF NOT EXISTS client_deposits (id INT AUTO_INCREMENT PRIMARY KEY, client_id INT NOT NULL, amount DECIMAL(18,6) NOT NULL, currency VARCHAR(8) NOT NULL, method VARCHAR(64) NOT NULL, reference VARCHAR(128) NULL, status VARCHAR(32) NOT NULL DEFAULT 'approved', created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"); } catch (Throwable $__) {}
                    try { $pdo->exec("CREATE TABLE IF NOT EXISTS client_transactions (id INT AUTO_INCREMENT PRIMARY KEY, client_id INT NOT NULL, type VARCHAR(32) NOT NULL, amount DECIMAL(18,6) NOT NULL, currency VARCHAR(8) NOT NULL, reference VARCHAR(128) NULL, notes TEXT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"); } catch (Throwable $__) {}
                    $stmtDep = $pdo->prepare("INSERT INTO client_deposits (client_id, amount, currency, method, reference, status) VALUES (?,?,?,?,?, 'approved')");
                    $stmtDep->execute([$clientId, $amountVal, $currency, 'key2pay', $identifier]);
                    $stmtTx = $pdo->prepare("INSERT INTO client_transactions (client_id, type, amount, currency, reference, notes) VALUES (?,?,?,?,?,?)");
                    $stmtTx->execute([$clientId, 'deposit', $amountVal, $currency, $identifier, 'Key2Pay']);
                    if ($accNum !== '') {
                        // Portal
                        $stmtAcc = $pdo->prepare("UPDATE client_accounts SET balance = balance + ? WHERE client_id = ? AND account_number = ?");
                        $stmtAcc->execute([$amountVal, $clientId, $accNum]);
                        // Webtrader
                        $stmtTa = $pdo->prepare("UPDATE trading_accounts SET balance = balance + ?, equity = equity + ?, free_margin = free_margin + ?, updated_at = NOW() WHERE client_id = ? AND account_number = ?");
                        $stmtTa->execute([$amountVal, $amountVal, $amountVal, $clientId, $accNum]);
                    }
                }
            }
        }
    }

    echo json_encode(['success'=>true]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
